package gov.va.med.mhv.adminPortal.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DatabaseConnection {

    private static final String CONFIG_LOCATION_PROPERTY = "config.location";
    private static final String PROPERTIES_FILE_NAME = "/uup.properties";
    private static final String JNDI_PROPERTY_NAME = "uup.jndiName";
    private static Properties UUP_PROPERTIES = null;
    
	public static Connection getConnection() throws SQLException {
		
		InputStream is = null;
		try {
			is = new FileInputStream (System.getProperty(CONFIG_LOCATION_PROPERTY) + PROPERTIES_FILE_NAME);
			UUP_PROPERTIES = new Properties();
			UUP_PROPERTIES.load(is);
			if (UUP_PROPERTIES.containsKey(JNDI_PROPERTY_NAME)) {
				String jndiName = UUP_PROPERTIES.getProperty(JNDI_PROPERTY_NAME);
				Context jndiCntxt = new InitialContext();
				DataSource ds = (DataSource)jndiCntxt.lookup(jndiName);
				return ds.getConnection();
			}
		}
		catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		catch (IOException e) {
			e.printStackTrace();
		}
		catch (NamingException e) {
			e.printStackTrace();
		}
		finally{
			if(is!=null){
				 try {
				      is.close();
				    } catch (IOException e) {
				      e.printStackTrace();
				    }				
			}
		}
		return null;
	}
	
	public static void closeConnection(Connection conn) {
		try {
			conn.close();
		}
		catch (SQLException e) {
			e.printStackTrace();
		}
		return;
	}
	
}
